// ExportGifDialog.cpp: Implementierungsdatei
//

#include "stdafx.h"
#include "gmnview32.h"
#include "ExportGifDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// Dialogfeld CExportGifDialog 


CExportGifDialog::CExportGifDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CExportGifDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CExportGifDialog)
	m_adjustpagesize = TRUE;
	m_page = 1;
	m_sizex = 400;
	m_sizey = 600;
	m_zoomfactor = 1.0f;
	m_filename = _T("");
	m_pagerange = _T("");
	//}}AFX_DATA_INIT
	
}


void CExportGifDialog::DoDataExchange(CDataExchange* pDX)
{
	
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CExportGifDialog)
	DDX_Control(pDX, IDC_FILENAME, m_ctrl_filename);
	DDX_Control(pDX, IDC_SELECTZOOM, m_ctrl_selectzoom);
	DDX_Control(pDX, IDC_ZOOMFACTOR, m_ctrl_zoom);
	DDX_Control(pDX, IDC_SIZEY, m_ctrl_sizey);
	DDX_Control(pDX, IDC_SIZEX, m_ctrl_sizex);
	DDX_Check(pDX, IDC_ADJUSTPAGESIZE, m_adjustpagesize);
	DDX_Text(pDX, IDC_PAGENUM, m_page);
	DDV_MinMaxUInt(pDX, m_page, 1, m_numpages);
	DDX_Text(pDX, IDC_SIZEX, m_sizex);
	DDV_MinMaxUInt(pDX, m_sizex, 10, 1600);
	DDX_Text(pDX, IDC_SIZEY, m_sizey);
	DDV_MinMaxUInt(pDX, m_sizey, 10, 1600);
	DDX_Text(pDX, IDC_ZOOMFACTOR, m_zoomfactor);
	DDV_MinMaxFloat(pDX, m_zoomfactor, 0.1f, 3.f);
	DDX_Text(pDX, IDC_FILENAME, m_filename);
	DDV_MaxChars(pDX, m_filename, 512);
	DDX_Text(pDX, IDC_PAGERANGE, m_pagerange);
	//}}AFX_DATA_MAP

}


BEGIN_MESSAGE_MAP(CExportGifDialog, CDialog)
	//{{AFX_MSG_MAP(CExportGifDialog)
	ON_BN_CLICKED(IDC_SELECTZOOM, OnSelectzoom)
	ON_BN_CLICKED(IDC_SELECTSIZE, OnSelectsize)
	ON_BN_CLICKED(IDC_SELECTFILENAME, OnSelectfilename)
	ON_BN_CLICKED(IDC_ADJUSTPAGESIZE, OnAdjustpagesize)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// Behandlungsroutinen fr Nachrichten CExportGifDialog 

void CExportGifDialog::OnSelectzoom() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	m_ctrl_sizex.EnableWindow(FALSE);
	m_ctrl_sizey.EnableWindow(FALSE);
	m_ctrl_zoom.EnableWindow(TRUE);
	m_iszoom = TRUE;
}

void CExportGifDialog::OnSelectsize() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	m_ctrl_sizex.EnableWindow(TRUE);
	m_ctrl_sizey.EnableWindow(TRUE);
	m_ctrl_zoom.EnableWindow(FALSE);

	m_iszoom = FALSE;

}

BOOL CExportGifDialog::Create(LPCTSTR lpszClassName, LPCTSTR lpszWindowName, DWORD dwStyle, const RECT& rect, CWnd* pParentWnd, UINT nID, CCreateContext* pContext) 
{
	// TODO: Speziellen Code hier einfgen und/oder Basisklasse aufrufen
	
	return CDialog::Create(IDD, pParentWnd);
}

BOOL CExportGifDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Zustzliche Initialisierung hier einfgen
	OnSelectzoom();
	m_ctrl_selectzoom.SetCheck(1);
	m_iszoom = TRUE;
	
	char buf[50];
	sprintf(buf,"(%d-%d)",1,m_numpages);
	m_pagerange = buf;
	UpdateData(FALSE);

	int ln = m_filename.GetLength();
	m_ctrl_filename.SetSel(ln,ln);

	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX-Eigenschaftenseiten sollten FALSE zurckgeben
}

void CExportGifDialog::OnSelectfilename() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
		// TODO: Code fr Befehlsbehandlungsroutine hier einfgen
	CFileDialog fileDialog(FALSE,".gif",this->m_filename,OFN_HIDEREADONLY 
		| OFN_PATHMUSTEXIST,
		"GIF file(*.gif)|*.gif||",this);

	fileDialog.m_ofn.lpstrTitle = "Export GIF File";
// 	fileDialog.m_ofn.lpstrInitialDir = pathName;

	if (fileDialog.DoModal() == IDOK)
	{
		// then we have a new filename ...
		m_filename = fileDialog.GetPathName();
		this->UpdateData(FALSE);
		
	}
}

void CExportGifDialog::OnAdjustpagesize() 
{
	// TODO: Code fr die Behandlungsroutine der Steuerelement-Benachrichtigung hier einfgen
	if (m_adjustpagesize)
	{
		m_adjustpagesize = FALSE;
	}
	else
		m_adjustpagesize = TRUE;

}
